@echo off
setlocal EnableExtensions EnableDelayedExpansion
chcp 65001 > nul

REM ===========================
REM 설정값
REM ===========================
set "SCRIPT=DesktopSortByExt_real.ps1"
set "PASSWORD=1234"
set "COUNTDOWN=5"
set "LOGDIR=_SORT_LOGS"

REM Desktop path
set "DESKTOP=%USERPROFILE%\Desktop"
set "LOGPATH=%DESKTOP%\%LOGDIR%"
if not exist "%LOGPATH%" mkdir "%LOGPATH%" >nul 2>&1

REM Timestamp (locale-safe: get from PowerShell)
for /f %%i in ('powershell -NoProfile -Command "Get-Date -Format yyyyMMdd_HHmmss"') do set "STAMP=%%i"
set "LOGFILE=%LOGPATH%\desktop_sort_%STAMP%.log"

echo ==========================================  > "%LOGFILE%"
echo   ⚠️  바탕화면 정리 프로그램 (실행 모드) >> "%LOGFILE%"
echo ========================================== >> "%LOGFILE%"
echo. >> "%LOGFILE%"
echo [작업 내용] >> "%LOGFILE%"
echo 1) 바탕화면 전체를 ZIP로 백업 >> "%LOGFILE%"
echo 2) 바탕화면의 파일만 확장자별로 정리 (폴더 제외) >> "%LOGFILE%"
echo. >> "%LOGFILE%"
echo [로그 파일] >> "%LOGFILE%"
echo %LOGFILE% >> "%LOGFILE%"
echo. >> "%LOGFILE%"

type "%LOGFILE%"

REM ===========================
REM 1) 암호 확인
REM ===========================
set /p "INPUTPW=암호를 입력하세요: "
if not "!INPUTPW!"=="%PASSWORD%" (
  echo. 
  echo ❌ 암호가 틀려서 작업을 취소합니다.
  echo [CANCEL] Wrong password >> "%LOGFILE%"
  pause
  exit /b 1
)
echo [OK] Password confirmed >> "%LOGFILE%"

REM ===========================
REM 2) 5초 카운트다운 자동 실행 (취소 가능)
REM ===========================
echo.
echo %COUNTDOWN%초 후 자동으로 실행됩니다. 취소하려면 N을 누르세요.
echo.

choice /C YN /N /T %COUNTDOWN% /D Y /M "실행하시겠습니까? (Y=실행, N=취소)"
if errorlevel 2 (
  echo.
  echo ❌ 사용자가 취소했습니다.
  echo [CANCEL] User cancelled >> "%LOGFILE%"
  pause
  exit /b 2
)
echo [OK] User confirmed >> "%LOGFILE%"

REM ===========================
REM 3) 실행 직전: 바탕화면 보이게 (Win + D)
REM ===========================
echo.
echo ▶ 실행 전, 열려있는 창을 최소화하여 바탕화면을 표시합니다...
echo [INFO] Show desktop (Win+D) >> "%LOGFILE%"

powershell -NoProfile -Command ^
  "$ws = New-Object -ComObject WScript.Shell; $ws.SendKeys('^{ESC}'); Start-Sleep -Milliseconds 150; $ws.SendKeys('^{ESC}');" >> "%LOGFILE%" 2>&1

REM ===========================
REM 4) PowerShell 실행 + 로그 저장
REM ===========================
echo.
echo ▶ 백업 + 정리를 시작합니다...
echo [RUN] powershell -File "%~dp0%SCRIPT%" -Run >> "%LOGFILE%"

powershell -NoProfile -ExecutionPolicy Bypass -File "%~dp0%SCRIPT%" -Run >> "%LOGFILE%" 2>&1

set "ERR=%ERRORLEVEL%"

echo.
if "%ERR%"=="0" (
  echo ✅ 완료되었습니다.
  echo [DONE] ExitCode=0 >> "%LOGFILE%"
) else (
  echo ⚠️ 오류가 발생했습니다. 로그를 확인하세요.
  echo [ERROR] ExitCode=%ERR% >> "%LOGFILE%"
)

echo.
echo 로그: %LOGFILE%
pause
exit /b %ERR%
